#ifndef _ODRM_TLK_ATP_TESTS_H_
#define _ODRM_TLK_ATP_TESTS_H_

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/


#ifdef __cplusplus
extern "C"
{
#endif

  /*
  *  Object %name    : %
  *  State           :  %state%
  *  Creation date   :  6-Dec-07
  *  Last modified   :  %modify_time%
  */
  /** @file
  *  \brief A brief description of this module
  *
  *  \version ODRM_TLK_ATP_tests.h#1:incl:1
  *  \author SagitB
  *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
  *           All Rights reserved
  */

  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_ODRM_KmacAndKmekEncryptUnderKri
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_ODRM_KmacAndKmekEncryptUnderKri
  *  
  * Algorithm: 
  * 1. Get work space size
  * 2. Initialize a Key Ring  
  * 3. insert Kmac and Kmek to the Key Ring 
  * 4. Call TLK_ODRM_KmacAndKmekEncryptUnderKri ,returns C
  * 5. Extract Kmac and Kmek from C by using the scheme in OMA DRM v2, section 7.2.4
  * 6. Validate this is the same Kmac and Kmek we crated C with
  *******************************************************************************/   

  DxError_t TST_ATP_TLK_ODRM_KmacAndKmekEncryptUnderKri(void);


  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_ODRM_KmacAndKmekDeriveUnderDomainKey
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_ODRM_KmacAndKrekDeriveUnderDomainKey
  *  
  * 1.  Get work space size 
  *.2   Init the key ring 
  * 3.  Insert KD  (domain Key) to the Key ring 
  * 4.  Perform  KDF (domain Generation on) KD 
  * 5.    Create C with Kd ,Kmac and Krek by using the scheme in OMA DRM v2, section 7.2.3
  * 6.    Call TLK_ODRM_KmacAndKrekDeriveUnderDomainKey
  * 7.    Activate Kmac and Krek from the key ring using the key ids received from the previous operation
  * 8.    Validate this is the same Kmac and Krek we crated C with
  *  8.1 preform HMAC with Kmac on plain text
  *  8.2 compare the result with plain text that was Hmac with Kmac in advance
  *  8.3 for verifying KD we will wrap a Cek key with Kd in advance
  *       perform  TLK_ODRM_AesUnwrapAndStore with kd as wrapping Key
  *       Encrypt plain text  with Cek key and compare with text we encrypted in advance with Cek
  *  8.4 load parameters and callTLK_ODRM_AesUnwrapAndStore
  *  8.5 Activate  Cek from the key ring using  the key id received from the previous operation
  *  8.6 Validate this is the same key we inserted in TLK_ODRM_AesUnwrapAndStore        
  *      by Encrypting   plain text with cek from key ring and comparing it with              
  *      Plain text we Encrypt in advance with original Cek
  *******************************************************************************/   

  DxError_t TST_ATP_TLK_ODRM_KmacAndKrekDeriveUnderDomainKey(void);


  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_ODRM_AesUnwrapAndStore
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_ODRM_AesUnwrapAndStore
  *  
  * Algorithm: 
  *1. Get work space size. 
  *2. Init the key Ring. 
  *3. Insert wrapper key Kek to the Key Ring. 
  *4. Load  parameters and call TLK_ODRM_AesUnwrapAndStore  unwraps the K and insert it to the Key Ring,
  *   returns key id.
  *5.	Activate  K from the key using  the key id received from the previous operation. 
  *6. Validate this is the same key we inserted in step 4.
  * 6.1  Encrypt Plain text with the K key from Key Ring ( from the id we received from the toolkit).
  * 6.2 compare it to the Encrypted plain text with the original K.
  *******************************************************************************/  
  DxError_t TST_ATP_TLK_ODRM_AesUnwrapAndStore(void);

  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_ODRM_AesUnwrapAndStore
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_ODRM_AesUnwrapAndStore
  *  
  * Algorithm: 
  * 1.Get work space size. 
  * 2.Encrypt The key data.
  * 3.Init the key ring.
  * 4.Insert The Encrypting Key to the key ring. 
  * 5.load parameters and  Call Call TLK_ODRM_AesKeyDecryptAndStore                                
  *   input the encrypted Key date buffer  and encrypting key id , output - decrypted key data id. 
  * 6.Activate the key data from the key ring using the handle we got in the previous operation.
  * 7.Validate this is the same key we inserted in step 5.
  *  7.1.Encrypt Plain text with the decrypted key from Key Ring ( from the id we received from the toolkit).
  *  7.2.Encrypt Plain text with the original key data before encryption.
  *  7.3.Compare results.
  *******************************************************************************/  
  DxError_t _TST_ATP_TLK_ODRM_AesKeyDecryptAndStore(CRYS_AES_OperationMode_t  aesOperationMode);

  DxError_t TST_ATP_TLK_ODRM_AesKeyDecryptAndStoreAllModes(void);

  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_ODRM_KmacAndKrekDeriveUnderDeviceKey
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_ODRM_KmacAndKrekDeriveUnderDeviceKey 
  *  
  * Algorithm:
  * 1. Get work space size
  * 2.  Init the Device key ring  
  * 3. Initialize a Key Ring 
  * 4. Import RSA private Key  with  KMNG_KEY_USAGE_ODRM and  TLK_ODRM_KEY_RESTRICTION
  * 5.  Create C with RSA Pub key Kmac and Krek by using the scheme in OMA DRM v2 section 7.2.1 
  * 6. Load  parameters  and Call TLK_ODRM_KmacAndKrekDeriveUnderDeviceKey
  * 7. Activate Kmac and Krek from the key ring using the key ids received from the previous operation
  * 8.  Verify that these are the same Krek and Kmac as expected
  *  8.1 preform HMAC with Kmac on plain text
  *  8.2 compare the result with plain text that was Hmac with Kmac in advance
  *  8.3 for verifying Krek we will wrap a Cek key with Krek in advance
  *       perform  TLK_ODRM_AesUnwrapAndStore with kd as wrapping Key
  *       Encrypt plain text  with Cek key and compare with text we encrypted in advance with Cek
  *  8.4 load parameters and callTLK_ODRM_AesUnwrapAndStore
  *  8.5 Activate  Cek from the key ring using  the key id received from the previous operation
  *  8.6 Validate this is the same key we inserted in TLK_ODRM_AesUnwrapAndStore        
  *      by Encrypting   plain text with cek from key ring and comparing it with              
  *      Plain text we Encrypt in advance with original Cek
  *******************************************************************************/ 
DxError_t TST_ATP_TLK_ODRM_KmacAndKrekDeriveUnderDeviceKey(void);
/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_TLK_ODRM_Cgenerator 
* 
* Inputs:
*  DxByte_t    * kMacAndkRekBuff     [in] concatanated kMac And kRek buffer
*  DxUint32_t    kMacAndkRekBuffSize [in] concatanated kMac And kRek buffer
*  DxUint8_t   * pubExponent         [in] Device key public exponent 
*  DxUint16_t    pubExponentSize     [in] Device key public exponent size
*  DxByte_t    * modulus,            [in] Device key modulus
*  DxUint16_t    modulusSize,        [in] Device key modulus Size
*  DxByte_t    *C,                   [out] the resualt of scheme OMA DRM v2 section 7.2.1
DxUint32_t CSize                  [in] C size
*
* return:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
*   Create C using scheme OMA DRM v2 section 7.2.1
*  
* Algorithm: 
* Create C with RSA Pub key Kmac and Krek by using the scheme in OMA DRM v2 section 7.2.1
*******************************************************************************/ 
DxError_t TST_ATP_TLK_ODRM_DEVKCgenerator(DxByte_t    * kMacAndkRekBuff,
                                          DxUint32_t    kMacAndkRekBuffSize,
                                          DxUint8_t   * pubExponent,
                                          DxUint16_t    pubExponentSize,
                                          DxByte_t    * modulus,
                                          DxUint16_t    modulusSize,
                                          DxByte_t    *C,
                                          DxUint32_t CSize  );

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_TLK_ODRM_KmacAndKdDeriveUnderDeviceKey
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
*    Test TLK_ODRM_KmacAndKdDeriveUnderDeviceKey 
*  
* Algorithm:
* 1. Get work space size 
* 2. Initialize a Key Ring 
* 3. Import RSA private Key  with   KMNG_KEY_USAGE_ODRM and  TLK_ODRM_KEY_RESTRICTION
* 4. Create C with RSA Pub key Kmac and Krek by using the scheme in OMA DRM v2 section 7.2.1 
* 5. Load  parameters  and Call TLK_ODRM_KmacAndKrekDeriveUnderDeviceKey
* 6. Activate Kmac and KD from the key ring using the key ids received from the previous operation
* 7. Verify that these are the same Kd and Kmac as expected
*  7.1 preform HMAC with Kmac on plain text
*  7.2 compare the result with plain text that was Hmac with Kmac in advance
*  7.3 for verifying KD we will wrap a Cek key with Kd in advance
*       perform  TLK_ODRM_AesUnwrapAndStore with kd as wrapping Key
*       Encrypt plain text  with Cek key and compare with text we encrypted in advance with Cek
*  7.4 load parameters and callTLK_ODRM_AesUnwrapAndStore
*  7.5 Activate  Cek from the key ring using  the key id received from the previous operation
*  7.6 Validate this is the same key we inserted in TLK_ODRM_AesUnwrapAndStore
*      by Encrypting   plain text with cek from key ring and comparing it with
*      Plain text we Encrypt in advance with original Cek
*******************************************************************************/ 

DxError_t TST_ATP_TLK_ODRM_KmacAndKdDeriveUnderDeviceKey(void);

#ifdef __cplusplus
}
#endif

#endif
